 ; Ŀ
 ;   Rain.                                                                 
 ;   Copyright 2004 by Rocket Software Ltd.                                
 ;   Not that computers are moody and reflective...                        
 ; 

 ; Ŀ
 ;   Subroutine Iri - grdraw circle maker with gaps.                       
 ; 
 (DEFUN IRI (pa radd reps colo / skip angg incr pa1 pa2)
  (setq skip 0)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (while (< 0 reps)
         (setq reps (1- reps))
         (setq angg (+ angg incr))
         (setq pa2 (polar pa angg radd))
         (if (or (zerop skip)
                 (not (= (rem reps skip) 0)))
             (grdraw pa1 pa2 colo))
         (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Iri end.                                                              
 ; 

 ; Ŀ
 ;   Raam - random screen position generator.                              
 ;   May contain excess code (introns) for the sake of reuse.              
 ; 
 (DEFUN RAAM (/ a vs ctr w maxx minx maxy miny s nnum pax pay)
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs a ))                       ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
 ; Ŀ
 ;   Horizontal.                                                           
 ; 
  (setq s (* (getvar "cdate") 10000000.0))
  (setq nnum (fix (* 100 (- s ( fix s)))))
  (setq pax (+ minx (* nnum w 0.02)))
 ; Ŀ
 ;   Vertical.                                                             
 ; 
  (setq s (* (getvar "cdate") 1000000.0))
  (setq nnum (fix (* 100 (- s ( fix s)))))
  (setq pay (+ miny (* nnum vs 0.02)))
 (list pax pay))
 ; Ŀ
 ;   Raam end.                                                             
 ; 

 ; Ŀ
 ;   Rain.                                                                 
 ; 
 (DEFUN RAIN (ring / colo pa rads rad)
  (setq colo -1)
 ; Ŀ
 ;   Get current ring data.                                                
 ; 
  (setq pa (car ring))
  (setq rads (cadr ring))
 ; Ŀ
 ;   Make and unmake rings as seems appropriate.                           
 ; 
  (while (and (setq rad (car rads))
              (= (type rad) 'REAL))
         (setq rads (cdr rads))
         (iri pa rad 64 colo)
         (command "delay" 7))
 (setq rads (cdr rads))
 ; Ŀ
 ;   Return the updated list.                                              
 ; 
 (list pa rads))
 ; Ŀ
 ;   Rain end.                                                             
 ; 

 ; Ŀ
 ;   Serra - generate a ring data list:                                    
 ;   (pa (radius1 ... radius6))                                            
 ;   Calls Raam.  Returns the list.                                        
 ; 
 (DEFUN SERRA (/ rad voo s nnum rincr ralist rads a b c d e f)
  (setq rad (/ (setq voo (getvar "viewsize")) 16))
  (setq s (* (getvar "cdate") 1000000.0))
  (setq nnum (fix (* 100 (- s ( fix s)))))
  (setq rad (* rad nnum 0.01))
  (if (< rad (/ voo 85))
      (setq rad (/ voo 45)))
  (setq rincr (/ rad 5))
  (repeat 6
          (setq ralist (cons rad ralist))
          (setq rad (+ rad rincr))
          (setq rincr (* rincr 0.75)))
  (setq ralist (reverse ralist))
  (setq rads (list (setq a (nth 0 ralist)) "p"
                   (setq b (nth 1 ralist)) "p"
                   (setq c (nth 2 ralist)) "p"
                   (setq d (nth 3 ralist)) "p" a
                   (setq e (nth 4 ralist)) "p" b
                   (setq f (nth 5 ralist)) "p" c "p" d "p" e "p" f))
 (list (raam) rads))
 ; Ŀ
 ;   Serra end.                                                            
 ; 

 ; Ŀ
 ;   Rain.                                                                 
 ; 
 (DEFUN C:RAIN (/ malist num pneuma sub)
 ; Ŀ
 ;   Process the master list.                                              
 ; 
  (repeat 250
 ; Ŀ
 ;   Generate ring data sublists, add them to the master list.             
 ; 
          (if (> 12 (length malist))
              (setq malist (append malist (list (serra)))))
 ; Ŀ
 ;   Process the master list.                                              
 ; 
          (setq num 0)
          (setq pneuma ())
          (while (setq sub (nth num malist))
                 (setq num (1+ num))
                 (setq sub (rain sub))
                 (if (last sub)
                     (setq pneuma (append pneuma (list sub)))
                     (setq pneuma (append pneuma (list (serra))))))
          (setq malist pneuma))
 ; Ŀ
 ;   Erase any leftover rings.                                             
 ; 
  (while malist
         (setq num 0)
         (setq pneuma ())
         (while (setq sub (nth num malist))
                (setq num (1+ num))
                (setq sub (rain sub))
                (if (last sub)
                    (setq pneuma (append pneuma (list sub)))))
         (setq malist pneuma))
 (princ))